% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program PTMcostfunc1.m
function L = PTMcostfunc1(guess, data)

NnoiseLevels = size(data, 1)/6;
NperformanceLevels = size(data, 2) - 1; 
        % # of stimulus conditions
beta = guess(1);
gamma = guess(2);
Nm = guess(3);
Sa = guess(4);
Af = guess(5);
data1 = data(1:3*NnoiseLevels, :);
data2 = data((3*NnoiseLevels+1):(6*NnoiseLevels), :);

L=0;
% unattended
for i = 1 : NnoiseLevels
    for j = 1 : NperformanceLevels
        Next = data1(i, 1);
        c = data1(i, j+1);
        m = data1(NnoiseLevels + i, j+1);
        k = data1(2*NnoiseLevels+i, j+1);
        dp = (beta*c)^gamma / sqrt(Next^(2*gamma)*(1+Nm^2) ...
            + Nm^2*(beta*c).^(2*gamma) + Sa^2);
         x = (-100:100)/10;
         dx = 0.10000000;
         p= sum(normpdf(x-dp).*normcdf(x).^3)*dx;  
         % compute percent correct 
        if (p < 1/2/(m+k))     
            % putting lower and upper boundaries on p
            p = 1/2/(m+k);
        elseif (p> 1-1/2/(m+k))
            p = 1- 1/2/(m+k);
        end
        L = L - (m*log(p) + k*log(1-p));
    end
end

% attended
for i = 1 : NnoiseLevels
    for j = 1 : NperformanceLevels
        Next = data2(i, 1);
        c = data2(i, j+1);
        m = data2(NnoiseLevels + i, j+1);
        k = data2(2*NnoiseLevels+i, j+1);
        dp = (beta*c)^gamma / ...
             sqrt((Af*Next)^(2*gamma)*(1 + Nm^2) ...
            + Nm^2*(beta*c).^(2*gamma) + Sa^2);
        x = (-100:100)/10;
        dx = 0.10000000;
        p= sum(normpdf(x-dp).*normcdf(x).^3)*dx;  
           % compute percent correct 
        if (p < 1/2/(m+k))     
            % putting lower and upper boundaries on p
            p = 1/2/(m+k);
        elseif (p> 1-1/2/(m+k))
            p = 1- 1/2/(m+k);
        end
        L = L - (m*log(p) + k*log(1-p));
    end
end
